unit EmapaLocalizeCOMClientImpl;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, ActiveX, AxCtrls, Classes, EmapaLocalizeCOM_TLB, StdVcl, dialogs ;

type

	TLongLatPoint = record
		Longitude: Double;
		Latitude: Double;
	end;

	TDegeocodeAtPointDatabaseResult = record
		Category: WideString;
		Name: WideString;
		ID: Integer;
		FoundPoint: TLongLatPoint;
		FoundLength: Double;
	end;

  TMouseClickEvent = procedure (Longitude: VARIANT; Latitude: VARIANT; Action: ActionEnum; CollectObj: IReportCollection; GeoInformation: IGeoInformation) of object;
  TGetInfObjectEvent = procedure (AInfObject : TDegeocodeAtPointDatabaseResult) of object;

type
  TDisplLocalizeCOMSink = class(TInterfacedObject, IUnknown, IDispatch)
  protected
    //IUnknown
    //Method resolution clause to allow QueryInterface to be redefined
    function IUnknown.QueryInterface = QueryInterface;
    function QueryInterface(const IID: TGUID; out Obj): HResult; stdcall;
    //IDispatch
    function GetTypeInfoCount(out Count: Integer): HResult; stdcall;
    function GetTypeInfo(Index, LocaleID: Integer; out TypeInfo): HResult; stdcall;
    function GetIDsOfNames(const IID: TGUID; Names: Pointer;
      NameCount, LocaleID: Integer; DispIDs: Pointer): HResult; stdcall;
    function Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult; stdcall;
  private
    FMouseClickEvent : TMouseClickEvent;
    FInfObjectEvent : TGetInfObjectEvent;
  public
    property OnGetInfObject : TGetInfObjectEvent read FInfObjectEvent write FInfObjectEvent;
    property OnMouseClickEvent : TMouseClickEvent read FMouseClickEvent write FMouseClickEvent;
    procedure AfterConstruction; override;
  end;

implementation

//uses EmapaLocalizeCOMImpl;

function TDisplLocalizeCOMSink.QueryInterface(const IID: TGUID; out Obj): HResult;
begin
  Result := E_NOINTERFACE;
  //If events interface requested, return IDispatch

  if IsEqualIID(IID, DIID_DispILocalizeInfo) then
  begin
    if GetInterface(IDispatch, Obj) then
      Result := S_OK
  end
  else
    //Handle other interface requests normally
    if GetInterface(IID, Obj) then
      Result := S_OK
end;

function TDisplLocalizeCOMSink.GetIDsOfNames(const IID: TGUID; Names: Pointer;
  NameCount, LocaleID: Integer; DispIDs: Pointer): HResult;
begin
  Result := E_NOTIMPL
end;

function TDisplLocalizeCOMSink.GetTypeInfo(Index, LocaleID: Integer;
  out TypeInfo): HResult;
begin
  Result := E_NOTIMPL
end;

function TDisplLocalizeCOMSink.GetTypeInfoCount(out Count: Integer): HResult;
begin
  Count := 0;
  Result := S_OK
end;

function TDisplLocalizeCOMSink.Invoke(DispID: Integer; const IID: TGUID;
  LocaleID: Integer; Flags: Word; var Params; VarResult, ExcepInfo,
  ArgErr: Pointer): HResult;
var
  AInfObject : TDegeocodeAtPointDatabaseResult;
  Args: PVariantArgList;
  LoLa : TLongLatPoint;
  LOperation : ActionEnum;
  LReportCollection : IReportCollection;
  LGeoInformation : IGeoInformation;
  //I : Integer;
begin
  Result := S_OK;
  //This is called to trigger an event interface method, if implemented
  //We need to check which one it is (by DispID) and do something sensible if we
  //support the triggered event
    case DispID of
      201:
         if Assigned(FMouseClickEvent) then
          begin
            Args := TDispParams(Params).rgvarg;
            LoLa.Longitude := Variant(Args^[4]);
            LoLa.Latitude := Variant(Args^[3]);
            LOperation := Variant(Args^[2]);
            LReportCollection := IUnknown(Args[1].unkVal) as IReportCollection;
            LGeoInformation := IUnknown(Args^[0].unkVal) as IGeoInformation;
            FMouseClickEvent(LoLa.Longitude, LoLa.Latitude, LOperation, LReportCollection, LGeoInformation);
          end;
      202:
          if Assigned(FInfObjectEvent) then
          begin
            Args := TDispParams(Params).rgvarg;
            AInfObject.Category := OleVariant(Args^[5]);
            AInfObject.Name := OleVariant(Args^[4]);
            AInfObject.ID := OleVariant(Args^[3]);
            AInfObject.FoundLength := OleVariant(Args^[2]);
            AInfObject.FoundPoint.Longitude := OleVariant(Args^[1]);
            AInfObject.FoundPoint.Latitude := OleVariant(Args^[0]);
            FInfObjectEvent(AInfObject);
          end;
      else
        //Ignore other events
    end
end;

procedure TDisplLocalizeCOMSink.AfterConstruction;
begin
   inherited;
end;
end.